! Writes current time <t>, BM-displacement <Y> and BM-velocity <V>
! of each probe-section to probe file (each call writes one row of data)
! If <storeBinary>, the values will be written as real(4)'s in a binary file.
! To process the binary data in Matlab use:
! fid = fopen ( '    probing file name    ' ) 
! x = fread(fid, [2n+2, inf], 'real*4')		%n indicating the number of probes
! t = x(:, 1)
! Y0 = x(:, 2) stapes
! Y1 = x(:, 3)
! Y2 = x(:, 4)
! ....
! V0 = x(:, n+2) stapes
! V1 = x(:, n+3)
! ....
! Vn = x(:, 2*n+3)

SUBROUTINE WriteProbing
	USE Declare
	USE GraphsModule
	USE FilesModule
	IMPLICIT NONE
	INTEGER ios

!	IF (storeProbing) THEN
		IF (storeBinary) THEN
			WRITE (FH_probing, IOSTAT = ios) REAL(t)
			WRITE (FH_probing, IOSTAT = ios) REAL(Y(0))
		ELSE
			WRITE (FH_probing, '($ES15.7)', IOSTAT = ios) t
			WRITE (FH_probing, '($ES15.5)', IOSTAT = ios) Y(0)
		ENDIF

		DO i = 1, 11
			IF (probes(i) > 0 .AND. probes(i) <=n) THEN
				IF (storeBinary) THEN
					WRITE (FH_probing, IOSTAT = ios) REAL(Y(probes(i)))
				ELSE
					WRITE (FH_probing, '($ES15.5)', IOSTAT = ios) Y(probes(i))
				ENDIF
			ENDIF
		ENDDO

		IF (storeBinary) THEN
			WRITE (FH_probing, IOSTAT = ios) REAL(V(0))
		ELSE
			WRITE (FH_probing, '($ES15.5)', IOSTAT = ios) V(0)
		ENDIF

		DO i = 1, 11
			IF (probes(i) > 0 .AND. probes(i) <=n) THEN
				IF (storeBinary) THEN
					WRITE (FH_probing, IOSTAT = ios) REAL(V(probes(i)))
				ELSE
					WRITE (FH_probing, '($ES15.5)', IOSTAT = ios) V(probes(i))
				ENDIF
			ENDIF
		ENDDO

		IF (.NOT. storeBinary) WRITE (FH_probing, *, IOSTAT = ios)
!	ENDIF
END SUBROUTINE WriteProbing